<?php include 'header.php'; ?>

    <!-- Page Hero -->
    <section class="page-hero">
        <div class="container">
            <h1>About SAGE STRATEGIES</h1>
            <p class="lead">Empowering businesses through innovation, expertise, and strategic solutions</p>
        </div>
    </section>

    <!-- Company Overview -->
    <section class="content-section">
        <div class="container">
            <div class="row align-items-center mb-5">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?w=800&h=600&fit=crop" alt="About SAGE STRATEGIES" class="img-fluid">
                </div>
                <div class="col-lg-6">
                    <h2 class="section-title text-start">Who We Are</h2>
                    <p class="lead text-muted">A multi-sector conglomerate dedicated to driving business excellence.</p>
                    <p>SAGE STRATEGIES is a dynamic, multi-sector conglomerate committed to empowering businesses across Nigeria and beyond. Founded with a vision to transform the business landscape, we provide integrated solutions that combine innovation, expertise, and strategic thinking to help our clients achieve sustainable growth and competitive advantage.</p>
                    <p>Our journey began with a simple yet powerful mission: to bridge the gap between traditional business practices and modern digital solutions. Today, we stand as a trusted partner for businesses of all sizes, from startups to established enterprises, offering comprehensive services across six key sectors.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Mission & Vision -->
    <section class="content-section bg-light">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-6">
                    <div class="card service-card p-4 h-100">
                        <div class="card-body">
                            <div class="service-icon">
                                <i class="fas fa-bullseye"></i>
                            </div>
                            <h3 class="card-title">Our Mission</h3>
                            <p class="card-text">To empower businesses across Nigeria and Africa by providing innovative, integrated solutions that drive growth, efficiency, and sustainable success. We are committed to delivering exceptional value through our diverse portfolio of services, helping our clients navigate the complexities of modern business operations.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card service-card p-4 h-100">
                        <div class="card-body">
                            <div class="service-icon">
                                <i class="fas fa-eye"></i>
                            </div>
                            <h3 class="card-title">Our Vision</h3>
                            <p class="card-text">To become Africa's leading multi-sector business solutions provider, recognized for excellence, innovation, and transformative impact. We envision a future where businesses of all sizes have access to world-class services that enable them to compete globally while contributing to local economic development.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Core Values -->
    <section class="content-section">
        <div class="container">
            <h2 class="section-title">Our Core Values</h2>
            <div class="row g-4 mt-3">
                <div class="col-md-6 col-lg-4">
                    <div class="feature-box">
                        <div class="service-icon">
                            <i class="fas fa-gem"></i>
                        </div>
                        <h5>Excellence</h5>
                        <p class="text-muted">We strive for excellence in everything we do, setting high standards and continuously improving our services to exceed client expectations.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="feature-box">
                        <div class="service-icon">
                            <i class="fas fa-lightbulb"></i>
                        </div>
                        <h5>Innovation</h5>
                        <p class="text-muted">We embrace innovation and leverage cutting-edge technologies to provide solutions that keep our clients ahead of the curve.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="feature-box">
                        <div class="service-icon">
                            <i class="fas fa-handshake"></i>
                        </div>
                        <h5>Integrity</h5>
                        <p class="text-muted">We conduct business with the highest ethical standards, building trust through transparency, honesty, and accountability.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="feature-box">
                        <div class="service-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <h5>Partnership</h5>
                        <p class="text-muted">We believe in building long-term partnerships with our clients, working collaboratively to achieve shared success.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="feature-box">
                        <div class="service-icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <h5>Sustainability</h5>
                        <p class="text-muted">We are committed to sustainable business practices that create value for our clients, communities, and the environment.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="feature-box">
                        <div class="service-icon">
                            <i class="fas fa-heart"></i>
                        </div>
                        <h5>Customer Focus</h5>
                        <p class="text-muted">Our clients are at the heart of everything we do. We listen, understand, and deliver solutions tailored to their unique needs.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Our Story -->
    <section class="content-section bg-light">
        <div class="container">
            <h2 class="section-title">Our Story</h2>
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="timeline-item">
                        <h5>2014 - The Beginning</h5>
                        <p class="text-muted">SAGE STRATEGIES was founded with a vision to revolutionize business operations across Nigeria. We started as a small team with big dreams, focusing initially on e-commerce and digital services.</p>
                    </div>
                    <div class="timeline-item">
                        <h5>2016 - Expansion</h5>
                        <p class="text-muted">Recognizing the growing need for integrated business solutions, we expanded into logistics and supply chain management, establishing strategic partnerships across the country.</p>
                    </div>
                    <div class="timeline-item">
                        <h5>2018 - Diversification</h5>
                        <p class="text-muted">We added construction and technical services to our portfolio, followed by human resources and consultancy services, becoming a true multi-sector conglomerate.</p>
                    </div>
                    <div class="timeline-item">
                        <h5>2020 - Digital Transformation</h5>
                        <p class="text-muted">Amidst global challenges, we accelerated our digital transformation initiatives, helping hundreds of businesses transition to online operations and modern business practices.</p>
                    </div>
                    <div class="timeline-item">
                        <h5>2024 - Today</h5>
                        <p class="text-muted">Today, SAGE STRATEGIES serves over 500 clients across six service sectors, with a team of 50+ experts dedicated to delivering excellence in every project we undertake.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Team Section -->
    <section class="content-section">
        <div class="container">
            <h2 class="section-title">Our Leadership Team</h2>
            <div class="row g-4 mt-3">
                <div class="col-md-6 col-lg-3">
                    <div class="card service-card text-center p-4">
                        <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&h=400&fit=crop" alt="CEO" class="img-fluid rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover; margin: 0 auto;">
                        <h5>John Adebayo</h5>
                        <p class="text-muted small">Chief Executive Officer</p>
                        <p class="text-muted small">15+ years in business strategy and operations</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="card service-card text-center p-4">
                        <img src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=400&h=400&fit=crop" alt="COO" class="img-fluid rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover; margin: 0 auto;">
                        <h5>Sarah Okonkwo</h5>
                        <p class="text-muted small">Chief Operating Officer</p>
                        <p class="text-muted small">Expert in logistics and supply chain management</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="card service-card text-center p-4">
                        <img src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=400&h=400&fit=crop" alt="CTO" class="img-fluid rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover; margin: 0 auto;">
                        <h5>Michael Okafor</h5>
                        <p class="text-muted small">Chief Technology Officer</p>
                        <p class="text-muted small">Digital transformation and innovation leader</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="card service-card text-center p-4">
                        <img src="https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=400&h=400&fit=crop" alt="CFO" class="img-fluid rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover; margin: 0 auto;">
                        <h5>Grace Eze</h5>
                        <p class="text-muted small">Chief Financial Officer</p>
                        <p class="text-muted small">Financial strategy and corporate finance expert</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Achievements -->
    <section class="content-section bg-light">
        <div class="container">
            <h2 class="section-title">Our Achievements</h2>
            <div class="row g-4 mt-3">
                <div class="col-md-6 col-lg-3">
                    <div class="stat-card">
                        <div class="stat-number">500+</div>
                        <h5>Happy Clients</h5>
                        <p class="text-muted small">Satisfied businesses across Nigeria</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="stat-card">
                        <div class="stat-number">1000+</div>
                        <h5>Projects Completed</h5>
                        <p class="text-muted small">Successful project deliveries</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="stat-card">
                        <div class="stat-number">50+</div>
                        <h5>Expert Team</h5>
                        <p class="text-muted small">Dedicated professionals</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="stat-card">
                        <div class="stat-number">10+</div>
                        <h5>Years Experience</h5>
                        <p class="text-muted small">Industry expertise</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-5" style="background: linear-gradient(135deg, var(--navy-blue) 0%, #003366 100%); color: white;">
        <div class="container text-center">
            <h2 class="mb-4">Partner With Us</h2>
            <p class="lead mb-4">Join hundreds of successful businesses that trust SAGE STRATEGIES</p>
            <a href="contact.php" class="btn btn-primary-custom">
                <i class="fas fa-paper-plane me-2"></i>Get In Touch
            </a>
        </div>
    </section>

<?php include 'footer.php'; ?>

