<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SAGE STRATEGIES - Empowering Businesses through Innovative Solutions</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --navy-blue: #001f3f;
            --slate-grey: #708090;
            --white: #ffffff;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }
        
        .navbar {
            background-color: var(--navy-blue) !important;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .navbar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--white) !important;
            display: flex;
            align-items: center;
        }
        
        .navbar-brand img {
            height: 50px;
            width: auto;
            margin-right: 10px;
        }
        
        .footer-logo {
            height: 60px;
            width: auto;
            margin-bottom: 1rem;
        }
        
        .navbar-nav .nav-link {
            color: rgba(255, 255, 255, 0.9) !important;
            font-weight: 500;
            margin: 0 0.5rem;
            transition: color 0.3s ease;
        }
        
        .navbar-nav .nav-link:hover {
            color: var(--white) !important;
        }
        
        .dropdown-menu {
            background-color: var(--navy-blue);
            border: none;
        }
        
        .dropdown-item {
            color: rgba(255, 255, 255, 0.9) !important;
        }
        
        .dropdown-item:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: var(--white) !important;
        }
        
        .hero-section {
            background: linear-gradient(135deg, var(--navy-blue) 0%, #003366 100%);
            color: var(--white);
            padding: 120px 0;
            text-align: center;
        }
        
        .hero-section h1 {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
            line-height: 1.2;
        }
        
        .hero-section p {
            font-size: 1.25rem;
            margin-bottom: 2rem;
            opacity: 0.95;
        }
        
        .btn-primary-custom {
            background-color: var(--white);
            color: var(--navy-blue);
            border: 2px solid var(--white);
            padding: 12px 40px;
            font-weight: 600;
            font-size: 1.1rem;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        
        .btn-primary-custom:hover {
            background-color: transparent;
            color: var(--white);
            border-color: var(--white);
            transform: translateY(-2px);
        }
        
        .services-section {
            padding: 80px 0;
            background-color: #f8f9fa;
        }
        
        .section-title {
            color: var(--navy-blue);
            font-weight: 700;
            margin-bottom: 3rem;
            text-align: center;
        }
        
        .service-card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            height: 100%;
            background-color: var(--white);
        }
        
        .service-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0,0,0,0.2);
        }
        
        .service-icon {
            font-size: 3rem;
            color: var(--navy-blue);
            margin-bottom: 1.5rem;
        }
        
        .service-card .card-title {
            color: var(--navy-blue);
            font-weight: 700;
            margin-bottom: 1rem;
        }
        
        .contact-section {
            padding: 80px 0;
            background-color: var(--white);
        }
        
        .form-control:focus {
            border-color: var(--navy-blue);
            box-shadow: 0 0 0 0.2rem rgba(0, 31, 63, 0.25);
        }
        
        .btn-submit {
            background-color: var(--navy-blue);
            color: var(--white);
            border: none;
            padding: 12px 40px;
            font-weight: 600;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        
        .btn-submit:hover {
            background-color: #003366;
            transform: translateY(-2px);
        }
        
        footer {
            background-color: var(--navy-blue);
            color: var(--white);
            padding: 40px 0 20px;
        }
        
        footer h5 {
            color: var(--white);
            margin-bottom: 1rem;
        }
        
        footer a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
        }
        
        footer a:hover {
            color: var(--white);
        }
        
        .page-hero {
            background: linear-gradient(135deg, var(--navy-blue) 0%, #003366 100%);
            color: var(--white);
            padding: 150px 0 80px;
            text-align: center;
        }
        
        .content-section {
            padding: 80px 0;
        }
        
        .img-fluid {
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        
        .stat-card {
            text-align: center;
            padding: 2rem;
            background: var(--white);
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: 700;
            color: var(--navy-blue);
        }
        
        .feature-box {
            padding: 2rem;
            background: var(--white);
            border-radius: 10px;
            margin-bottom: 2rem;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .timeline-item {
            position: relative;
            padding-left: 3rem;
            padding-bottom: 2rem;
        }
        
        .timeline-item::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            width: 2px;
            height: 100%;
            background: var(--navy-blue);
        }
        
        .timeline-item::after {
            content: '';
            position: absolute;
            left: -8px;
            top: 0;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: var(--navy-blue);
        }
        
        @media (max-width: 768px) {
            .hero-section h1 {
                font-size: 2rem;
            }
            
            .hero-section p {
                font-size: 1rem;
            }
            
            .page-hero {
                padding: 120px 0 60px;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <img src="images/logo.png" alt="SAGE STRATEGIES Logo" class="d-inline-block align-top">
                <span class="d-none d-md-inline">SAGE STRATEGIES</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">About</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="servicesDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Services
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="servicesDropdown">
                            <li><a class="dropdown-item" href="services.php"><i class="fas fa-shopping-cart me-2"></i>E-commerce</a></li>
                            <li><a class="dropdown-item" href="services.php"><i class="fas fa-truck me-2"></i>Logistics</a></li>
                            <li><a class="dropdown-item" href="services.php"><i class="fas fa-hard-hat me-2"></i>Construction</a></li>
                            <li><a class="dropdown-item" href="services.php"><i class="fas fa-users me-2"></i>HR & Manpower</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

