<?php include 'header.php'; ?>

    <!-- Page Hero -->
    <section class="page-hero">
        <div class="container">
            <h1>Our Services</h1>
            <p class="lead">Comprehensive solutions tailored to your business needs</p>
        </div>
    </section>

    <!-- Services Overview -->
    <section class="content-section">
        <div class="container">
            <div class="row mb-5">
                <div class="col-lg-8 mx-auto text-center">
                    <h2 class="section-title">What We Offer</h2>
                    <p class="lead text-muted">SAGE STRATEGIES provides end-to-end business solutions across six key sectors. Our integrated approach ensures seamless operations and maximum efficiency for your business.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Service 1: E-Commerce & Digital Services -->
    <section class="content-section bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <img src="https://images.unsplash.com/photo-1556742049-0cfed4f6a45d?w=800&h=600&fit=crop" alt="E-Commerce Services" class="img-fluid">
                </div>
                <div class="col-lg-6">
                    <div class="service-icon">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <h2 class="section-title text-start">E-Commerce & Digital Services</h2>
                    <p class="lead text-muted">Transform your business with cutting-edge digital solutions</p>
                    <p>In today's digital-first economy, having a robust online presence is crucial. Our e-commerce and digital services division helps businesses establish and grow their digital footprint through comprehensive solutions.</p>
                    
                    <h5 class="mt-4 mb-3">What We Provide:</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Online Marketplace Development:</strong> Custom e-commerce platforms tailored to your business needs</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>POS Systems:</strong> Point-of-sale solutions for seamless transactions</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>ICT Services:</strong> Comprehensive information and communication technology solutions</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Digital Marketing:</strong> Online marketing strategies to boost your visibility</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Virtual Business Solutions:</strong> Complete virtualization of business processes</li>
                    </ul>
                    
                    <a href="contact.php" class="btn btn-submit mt-3">
                        <i class="fas fa-arrow-right me-2"></i>Get Started
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Service 2: Retail, Trade & Distribution -->
    <section class="content-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0 order-lg-2">
                    <img src="https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=800&h=600&fit=crop" alt="Retail & Distribution" class="img-fluid">
                </div>
                <div class="col-lg-6 order-lg-1">
                    <div class="service-icon">
                        <i class="fas fa-store"></i>
                    </div>
                    <h2 class="section-title text-start">Retail, Trade & Distribution</h2>
                    <p class="lead text-muted">Comprehensive trade solutions from local to global</p>
                    <p>Our retail, trade, and distribution services cover the entire supply chain, from sourcing to delivery. We operate both online and physical retail outlets, ensuring your products reach customers wherever they are.</p>
                    
                    <h5 class="mt-4 mb-3">Our Services Include:</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Retail Outlets:</strong> Supermarts, departmental stores, and hypermarkets</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>General Merchandise:</strong> Food supplements, provisions, and consumer goods</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Import/Export:</strong> Global trade in textiles, beverages, and building materials</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Distribution Network:</strong> Extensive network for efficient product distribution</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Wholesale Operations:</strong> Bulk supply solutions for retailers</li>
                    </ul>
                    
                    <a href="contact.php" class="btn btn-submit mt-3">
                        <i class="fas fa-arrow-right me-2"></i>Learn More
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Service 3: Logistics & Supply Chain -->
    <section class="content-section bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <img src="https://images.unsplash.com/photo-1586528116311-ad8dd3c8310d?w=800&h=600&fit=crop" alt="Logistics Services" class="img-fluid">
                </div>
                <div class="col-lg-6">
                    <div class="service-icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h2 class="section-title text-start">Logistics & Supply Chain</h2>
                    <p class="lead text-muted">Streamline your operations with efficient logistics solutions</p>
                    <p>Efficient logistics is the backbone of successful business operations. Our comprehensive logistics services ensure your goods are transported, stored, and delivered on time, every time.</p>
                    
                    <h5 class="mt-4 mb-3">What We Offer:</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Land Transportation:</strong> Reliable road transport services across Nigeria</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Warehousing:</strong> Secure storage facilities with modern inventory management</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Haulage Services:</strong> Heavy-duty transportation for bulk goods</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Equipment Leasing:</strong> Rent heavy-duty equipment for your operations</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Correspondence Services:</strong> Document and package delivery</li>
                    </ul>
                    
                    <a href="contact.php" class="btn btn-submit mt-3">
                        <i class="fas fa-arrow-right me-2"></i>Get Quote
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Service 4: Construction & Technical Services -->
    <section class="content-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0 order-lg-2">
                    <img src="https://images.unsplash.com/photo-1504307651254-35680f356dfd?w=800&h=600&fit=crop" alt="Construction Services" class="img-fluid">
                </div>
                <div class="col-lg-6 order-lg-1">
                    <div class="service-icon">
                        <i class="fas fa-hard-hat"></i>
                    </div>
                    <h2 class="section-title text-start">Construction & Technical Services</h2>
                    <p class="lead text-muted">Build with confidence and precision</p>
                    <p>From residential homes to large-scale infrastructure projects, our construction division delivers quality workmanship and technical excellence. We handle every aspect of construction, from design to completion.</p>
                    
                    <h5 class="mt-4 mb-3">Our Expertise:</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Building Construction:</strong> Residential, commercial, and public buildings</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Infrastructure Projects:</strong> Schools, hospitals, and public utilities</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Repair & Renovation:</strong> Building maintenance and restoration</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Technical Services:</strong> Industrial and technical solutions</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Cleaning Services:</strong> Corporate and domestic cleaning solutions</li>
                    </ul>
                    
                    <a href="contact.php" class="btn btn-submit mt-3">
                        <i class="fas fa-arrow-right me-2"></i>Start Project
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Service 5: Human Resources & Consultancy -->
    <section class="content-section bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <img src="https://images.unsplash.com/photo-1521737604893-d14cc237f11d?w=800&h=600&fit=crop" alt="HR Services" class="img-fluid">
                </div>
                <div class="col-lg-6">
                    <div class="service-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h2 class="section-title text-start">Human Resources & Consultancy</h2>
                    <p class="lead text-muted">Unlock your workforce potential</p>
                    <p>Your people are your greatest asset. Our HR and consultancy services help you find, train, and retain the right talent while optimizing your workforce for maximum productivity.</p>
                    
                    <h5 class="mt-4 mb-3">Services We Provide:</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Recruitment:</strong> Find the right talent for your organization</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Training & Development:</strong> Upskill your workforce with professional training</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Labor Supply:</strong> Skilled and unskilled labor solutions</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Outsourcing:</strong> Office support and logistics support services</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Business Representation:</strong> Act as commission agents and manufacturers' representatives</li>
                    </ul>
                    
                    <a href="contact.php" class="btn btn-submit mt-3">
                        <i class="fas fa-arrow-right me-2"></i>Contact HR Team
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Service 6: Corporate & Financial Solutions -->
    <section class="content-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0 order-lg-2">
                    <img src="https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?w=800&h=600&fit=crop" alt="Corporate Solutions" class="img-fluid">
                </div>
                <div class="col-lg-6 order-lg-1">
                    <div class="service-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <h2 class="section-title text-start">Corporate & Financial Solutions</h2>
                    <p class="lead text-muted">Navigate corporate complexities with confidence</p>
                    <p>Corporate growth requires strategic financial planning and comprehensive business solutions. We provide the expertise and resources needed to navigate complex corporate challenges and achieve sustainable growth.</p>
                    
                    <h5 class="mt-4 mb-3">Our Solutions:</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Financial Strategy:</strong> Strategic financial planning and management</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Capital Management:</strong> Optimize your capital structure</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Corporate Services:</strong> Comprehensive corporate support services</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Business Advisory:</strong> Expert guidance for business decisions</li>
                        <li class="mb-2"><i class="fas fa-check-circle text-primary me-2"></i><strong>Growth Solutions:</strong> Strategies for business expansion</li>
                    </ul>
                    
                    <a href="contact.php" class="btn btn-submit mt-3">
                        <i class="fas fa-arrow-right me-2"></i>Schedule Consultation
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Service Cards Grid -->
    <section class="services-section">
        <div class="container">
            <h2 class="section-title">Quick Service Overview</h2>
            <div class="row g-4">
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-shopping-cart"></i>
                            </div>
                            <h5 class="card-title">E-Commerce</h5>
                            <p class="card-text text-muted">Digital transformation and online marketplace solutions</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-store"></i>
                            </div>
                            <h5 class="card-title">Retail & Trade</h5>
                            <p class="card-text text-muted">Comprehensive retail and distribution services</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-truck"></i>
                            </div>
                            <h5 class="card-title">Logistics</h5>
                            <p class="card-text text-muted">Efficient transportation and supply chain management</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-hard-hat"></i>
                            </div>
                            <h5 class="card-title">Construction</h5>
                            <p class="card-text text-muted">Quality construction and technical services</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <h5 class="card-title">HR & Consultancy</h5>
                            <p class="card-text text-muted">Workforce solutions and business consultancy</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card service-card p-4">
                        <div class="card-body text-center">
                            <div class="service-icon">
                                <i class="fas fa-briefcase"></i>
                            </div>
                            <h5 class="card-title">Corporate Solutions</h5>
                            <p class="card-text text-muted">Strategic financial and corporate services</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-5" style="background: linear-gradient(135deg, var(--navy-blue) 0%, #003366 100%); color: white;">
        <div class="container text-center">
            <h2 class="mb-4">Ready to Get Started?</h2>
            <p class="lead mb-4">Let's discuss how our services can transform your business</p>
            <a href="contact.php" class="btn btn-primary-custom">
                <i class="fas fa-paper-plane me-2"></i>Contact Us Today
            </a>
        </div>
    </section>

<?php include 'footer.php'; ?>

